/*
 * Decompiled with CFR 0.152.
 */
package modules;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JPanel;
import modules.CharGenerator;

public class LedMatrix
extends JPanel {
    private int xCoord;
    private int yCoord;
    private int dotSize = 3;
    private int dotSpace = 1;
    private int nrDotsX = 128;
    private int nrDotsY = 32;
    private Color onDotColor = Color.cyan;
    private Color offDotColor = new Color(50, 50, 50);
    private Color bgColor = new Color(20, 20, 20);
    private boolean[][] activeDotAr = new boolean[this.nrDotsX][this.nrDotsY];

    public LedMatrix(int xCoord, int yCoord) {
        this.init(xCoord, yCoord);
    }

    public LedMatrix() {
        this.init(0, 0);
    }

    private void init(int xCoord, int yCoord) {
        this.xCoord = xCoord;
        this.yCoord = yCoord;
        this.setLayout(null);
        this.setBounds(xCoord, yCoord, this.nrDotsX * (this.dotSize + this.dotSpace), this.nrDotsY * (this.dotSize + this.dotSpace));
    }

    public void clrScreen() {
        for (int idy = 0; idy < this.nrDotsY; ++idy) {
            for (int idx = 0; idx < this.nrDotsX; ++idx) {
                this.activeDotAr[idx][idy] = false;
            }
        }
        this.repaint();
    }

    public void lightScreen() {
        for (int idy = 0; idy < this.nrDotsY; ++idy) {
            for (int idx = 0; idx < this.nrDotsX; ++idx) {
                this.activeDotAr[idx][idy] = true;
            }
        }
        this.repaint();
    }

    public void scroll(int xStep, int yStep) {
        int iy;
        int ix;
        if (xStep > 0) {
            for (ix = this.nrDotsX - 1; ix >= 0; --ix) {
                this.copyColumn(ix - xStep, ix);
            }
        }
        if (xStep < 0) {
            for (ix = 0; ix < this.nrDotsX; ++ix) {
                this.copyColumn(ix - xStep, ix);
            }
        }
        if (yStep > 0) {
            for (iy = this.nrDotsY - 1; iy >= 0; --iy) {
                this.copyRow(iy - yStep, iy);
            }
        }
        if (yStep < 0) {
            for (iy = 0; iy < this.nrDotsY; ++iy) {
                this.copyRow(iy - yStep, iy);
            }
        }
        this.repaint();
    }

    private void copyColumn(int xFrom, int xTo) {
        if (xTo < 0 || xTo >= this.nrDotsX) {
            return;
        }
        if (xFrom < 0 || xFrom >= this.nrDotsX) {
            for (int y = 0; y < this.nrDotsY; ++y) {
                this.activeDotAr[xTo][y] = false;
            }
        } else {
            for (int y = 0; y < this.nrDotsY; ++y) {
                this.activeDotAr[xTo][y] = this.activeDotAr[xFrom][y];
            }
        }
    }

    private void copyRow(int yFrom, int yTo) {
        if (yTo < 0 || yTo >= this.nrDotsY) {
            return;
        }
        if (yFrom < 0 || yFrom >= this.nrDotsY) {
            for (int x = 0; x < this.nrDotsX; ++x) {
                this.activeDotAr[x][yTo] = false;
            }
        } else {
            for (int x = 0; x < this.nrDotsX; ++x) {
                this.activeDotAr[x][yTo] = this.activeDotAr[x][yFrom];
            }
        }
    }

    public void setDotXYOn(int x, int y) {
        if (x < this.nrDotsX && y < this.nrDotsY) {
            this.activeDotAr[x][y] = true;
        }
    }

    public void setDotXYOff(int x, int y) {
        if (x < this.nrDotsX && y < this.nrDotsY) {
            this.activeDotAr[x][y] = false;
        }
    }

    public void drawString(int x, int y, String str) {
        for (int idx = 0; idx < str.length(); ++idx) {
            this.drawChar(x + idx * 6, y, str.charAt(idx));
        }
    }

    public void drawChar(int x, int y, char c) {
        CharGenerator rom = new CharGenerator();
        byte[] mask = new byte[8];
        mask = rom.getRomPattern(c);
        for (int idy = 0; idy < 8; ++idy) {
            for (int idx = 0; idx < 6; ++idx) {
                if (x + idx >= this.nrDotsX || y + idy >= this.nrDotsY) continue;
                this.activeDotAr[x + idx][y + idy] = 0 != (mask[idy] << idx + 2 & 0x80);
            }
        }
        this.repaint();
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(this.bgColor);
        g.fillRect(this.xCoord, this.yCoord, this.nrDotsX * (this.dotSize + this.dotSpace), this.nrDotsY * (this.dotSize + this.dotSpace));
        int x = this.xCoord;
        int y = this.yCoord;
        for (int idy = 0; idy < this.nrDotsY; ++idy) {
            for (int idx = 0; idx < this.nrDotsX; ++idx) {
                if (this.activeDotAr[idx][idy]) {
                    g.setColor(this.onDotColor);
                } else {
                    g.setColor(this.offDotColor);
                }
                g.fillRect(x, y, this.dotSize, this.dotSize);
                x += this.dotSize + this.dotSpace;
            }
            y += this.dotSize + this.dotSpace;
            x = this.xCoord;
        }
    }
}

