/*
 * Decompiled with CFR 0.152.
 */
package wsGUI;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import wsGUI.IORegisterListener;

public class IOServer
implements Runnable {
    private static final int DEFAULT_LISTEN_PORT = 81;
    private static ArrayList modules = new ArrayList();
    private static int port = 81;
    private static IOServer singleInstance;
    private static Thread serverThread;
    private static boolean running;
    private static String remoteHost;
    private static String localHost;

    private IOServer() {
    }

    public static void start() {
        serverThread.start();
    }

    public static void start(int newPort) {
        port = newPort;
        serverThread.start();
    }

    public static void stop() {
        running = false;
    }

    public static synchronized void addIORegisterListener(IORegisterListener mod) {
        modules.add(mod);
    }

    public static synchronized void removeAllListeners() {
        modules.clear();
    }

    public static synchronized void writeShort(short address, short value) {
        for (IORegisterListener mod : modules) {
            if (address < mod.getBaseAddress() || address >= mod.getBaseAddress() + 2 * mod.getNumberOfRegisters()) continue;
            mod.writeShort(address, value);
        }
    }

    public static synchronized short readShort(short address) {
        for (IORegisterListener mod : modules) {
            if (address < mod.getBaseAddress() || address >= mod.getBaseAddress() + 2 * mod.getNumberOfRegisters()) continue;
            return mod.readShort(address);
        }
        return 0;
    }

    public static String getLocalHostIP() {
        return localHost;
    }

    public void run() {
        try {
            System.out.println("Server is running on " + localHost);
            ServerSocket socket = new ServerSocket(port);
            socket.setSoTimeout(1000);
            while (running) {
                try {
                    Socket s = socket.accept();
                    this.handleRequests(s);
                }
                catch (IOException iOException) {}
            }
            socket.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        running = false;
        System.out.println("Server has stopped");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRequests(Socket s) {
        FilterInputStream input = null;
        FilterOutputStream output = null;
        try {
            remoteHost = s.getRemoteSocketAddress().toString();
            System.out.println("Start handling incoming request from IP=" + remoteHost);
            s.setTcpNoDelay(true);
            output = new DataOutputStream(new BufferedOutputStream(s.getOutputStream()));
            input = new DataInputStream(new BufferedInputStream(s.getInputStream()));
            while (s.isConnected()) {
                short opcode = ((DataInputStream)input).readShort();
                short address = ((DataInputStream)input).readShort();
                short value = ((DataInputStream)input).readShort();
                if (opcode == 1) {
                    IOServer.writeShort(address, value);
                } else {
                    value = IOServer.readShort(address);
                }
                ((DataOutputStream)output).writeShort(value);
                ((DataOutputStream)output).flush();
            }
        }
        catch (Exception e) {
        }
        finally {
            try {
                if (output != null) {
                    output.close();
                }
                if (input != null) {
                    input.close();
                }
                s.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        System.out.println("Connection closed");
    }

    static {
        System.out.println("Starting server");
        singleInstance = new IOServer();
        serverThread = new Thread(singleInstance);
        running = true;
        remoteHost = "";
        try {
            InetAddress address = InetAddress.getLocalHost();
            localHost = address.getHostAddress();
        }
        catch (UnknownHostException e) {
            localHost = "Could not find the local address";
        }
    }
}

