/*
 * Decompiled with CFR 0.152.
 */
package modules;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class SevenSeg
extends JPanel {
    static ImageIcon iconBG = new ImageIcon(SevenSeg.class.getResource("7segm_bg.png"));
    static Image imageBG = null;
    static Dimension myDim = null;
    static Image[] imageSegment = new Image[8];
    static int[] digitPattern = new int[]{63, 6, 91, 79, 102, 109, 125, 7, 127, 111, 119, 124, 57, 94, 121, 113};
    private int pattern = 0;

    public SevenSeg() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        if (imageBG == null) {
            if (iconBG != null) {
                imageBG = iconBG.getImage();
                myDim = new Dimension(iconBG.getIconWidth(), iconBG.getIconHeight());
            } else {
                myDim = new Dimension(10, 10);
            }
        }
        char segment = 'a';
        for (int i = 0; i < 8; ++i) {
            ImageIcon tmp;
            if (imageSegment[i] == null && (tmp = new ImageIcon(SevenSeg.class.getResource("7segm_" + segment + ".png"))) != null) {
                SevenSeg.imageSegment[i] = tmp.getImage();
            }
            segment = (char)(segment + 1);
        }
    }

    public int getPattern() {
        return this.pattern;
    }

    public void setPattern(int pattern) {
        if ((pattern & 0x100) == 0) {
            int digit = pattern & 0xF;
            pattern = digitPattern[digit];
        }
        this.pattern = pattern;
    }

    public Dimension getPreferredSize() {
        return myDim;
    }

    public Dimension getMinimumSize() {
        return myDim;
    }

    protected void paintComponent(Graphics g) {
        g.drawImage(imageBG, 0, 0, this);
        int bit = 1;
        for (int i = 0; i < 8; ++i) {
            if ((this.pattern & bit) == bit) {
                g.drawImage(imageSegment[i], 0, 0, this);
            }
            bit <<= 1;
        }
    }
}

