/*
 * Decompiled with CFR 0.152.
 */
package modules;

import javax.swing.JPanel;
import wsGUI.IORegisterListener;
import wsGUI.IOServer;

public class BaseModule
extends JPanel
implements IORegisterListener {
    protected short baseAddress;
    protected short numberOfRegisters;
    protected short[] registers;

    public BaseModule() {
        this(0, 1);
    }

    public BaseModule(short base) {
        this(base, 1);
    }

    public BaseModule(short base, short num) {
        if (base < 0) {
            base = 0;
        }
        if (num < 1) {
            num = 1;
        }
        this.baseAddress = base;
        this.numberOfRegisters = num;
        this.registers = new short[num];
        for (int i = 0; i < num; ++i) {
            this.registers[i] = 0;
        }
        IOServer.addIORegisterListener(this);
        String hex = Integer.toHexString(0x10000 | base).substring(1).toUpperCase();
        String ttt = "Adres= 0x" + hex + ", " + num + " register";
        if (num > 1) {
            ttt = ttt + "s";
        }
        this.setToolTipText(ttt);
    }

    public short getBaseAddress() {
        return this.baseAddress;
    }

    public short getNumberOfRegisters() {
        return this.numberOfRegisters;
    }

    public short readShort(short address) {
        return this.registers[this.registerNumber(address)];
    }

    public synchronized void writeShort(short address, short value) {
        this.registers[this.registerNumber((short)address)] = value;
        this.repaint();
    }

    protected int registerNumber(short address) {
        return (address - this.baseAddress) / 2;
    }

    public synchronized short getRegister(int offset) {
        if (offset > 0 && offset < this.numberOfRegisters) {
            return this.registers[offset];
        }
        return 0;
    }
}

