/*
 * Decompiled with CFR 0.152.
 */
package modules;

import java.awt.Component;
import java.awt.Insets;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import modules.BaseModule;

public class PushButtonArrayModule
extends BaseModule {
    public static final int MAX_NUMBER_OF_BUTTONS = 16;
    private JCheckBox[] m_buttons = new JCheckBox[16];
    private int m_nButtons = 0;
    private short m_status = 0;
    private String m_strColor = "Blue";
    private boolean m_bLockDown = true;
    private static ImageIcon iconOn = new ImageIcon(PushButtonArrayModule.class.getResource("KnopAan.png"));
    private static ImageIcon iconOff = new ImageIcon(PushButtonArrayModule.class.getResource("KnopUit.png"));
    private static ImageIcon iconOnRed = new ImageIcon(PushButtonArrayModule.class.getResource("KnopAanRood.png"));
    private static ImageIcon iconOffRed = new ImageIcon(PushButtonArrayModule.class.getResource("KnopUitRood.png"));

    public PushButtonArrayModule() {
        this(128, "Blue");
    }

    public PushButtonArrayModule(short base, String col) {
        super(base, (short)1);
        for (int i = 0; i < 16; ++i) {
            this.m_buttons[i] = new JCheckBox();
            this.m_buttons[i].setFocusPainted(false);
            this.m_buttons[i].setBorderPainted(false);
            this.m_buttons[i].setContentAreaFilled(false);
            this.m_buttons[i].setMargin(new Insets(0, 0, 0, 0));
            this.m_buttons[i].setIconTextGap(0);
            this.m_buttons[i].setIcon(iconOff);
            this.m_buttons[i].setSelectedIcon(iconOn);
            this.m_buttons[i].setToolTipText(this.getToolTipText());
        }
        this.setColor(col);
        this.setNumberButtons(1);
    }

    public void setNumberButtons(int newNumber) {
        if (newNumber >= 0 && newNumber <= 16) {
            this.m_nButtons = newNumber;
            this.removeAll();
            for (int i = 0; i < this.m_nButtons; ++i) {
                this.add((Component)this.m_buttons[i], null);
            }
            this.validate();
        }
    }

    public int getNumberButtons() {
        return this.m_nButtons;
    }

    public void setLockDown(boolean bLockDown) {
        this.m_bLockDown = bLockDown;
        this.resetAll();
    }

    public boolean getLockDown() {
        return this.m_bLockDown;
    }

    public void setColor(String color) {
        this.m_strColor = color;
        ImageIcon icon0 = iconOff;
        ImageIcon icon1 = iconOn;
        if (this.m_strColor.equals("Red")) {
            icon0 = iconOffRed;
            icon1 = iconOnRed;
        }
        for (int i = 0; i < 16; ++i) {
            this.m_buttons[i].setIcon(icon0);
            this.m_buttons[i].setSelectedIcon(icon1);
        }
    }

    public String getColor() {
        return this.m_strColor;
    }

    public short readShort(short address) {
        this.m_status = 0;
        int bit = 1;
        for (int i = 0; i < this.m_nButtons; ++i) {
            if (this.m_buttons[i].isSelected()) {
                this.m_status = (short)(this.m_status | bit);
            }
            bit = (short)(bit << 1);
        }
        if (!this.m_bLockDown) {
            this.resetAll();
        }
        return this.m_status;
    }

    private void resetAll() {
        for (int i = 0; i < this.m_nButtons; ++i) {
            this.m_buttons[i].setSelected(false);
        }
    }
}

