/*
 * Decompiled with CFR 0.152.
 */
package modules;

import java.awt.Dimension;
import java.awt.Rectangle;
import modules.BaseModule;
import modules.LedMatrix;

public class LedMatrixModule
extends BaseModule {
    private LedMatrix m_Matrix = new LedMatrix();
    private boolean m_bCommandMode = false;
    private int m_cursorLine = 0;
    private int m_cursorPos = 0;

    public LedMatrixModule() {
        this(64);
    }

    public LedMatrixModule(short base) {
        super(base, (short)2);
        this.setLayout(null);
        this.add(this.m_Matrix);
    }

    public Dimension getPreferredSize() {
        Rectangle r = this.m_Matrix.getBounds();
        return new Dimension(r.width, r.height);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public synchronized void writeShort(short address, short value) {
        if (address == this.baseAddress) {
            if (value == 254) {
                this.m_bCommandMode = true;
            } else if (this.m_bCommandMode) {
                switch (value) {
                    case 1: {
                        this.m_Matrix.clrScreen();
                        this.m_cursorLine = 0;
                        this.m_cursorPos = 0;
                        break;
                    }
                }
                this.m_bCommandMode = false;
            } else {
                switch (value) {
                    case 10: {
                        ++this.m_cursorLine;
                        this.m_cursorPos = 0;
                        break;
                    }
                    default: {
                        this.m_Matrix.drawChar(1 + this.m_cursorPos++ * 6, 2 + this.m_cursorLine * 10, (char)value);
                        break;
                    }
                }
            }
        } else if (address == this.baseAddress + 2) {
            int commandCode = (value & 0xF000) >> 12;
            int x = (value & 0xFE0) >> 5;
            int y = value & 0x1F;
            switch (commandCode) {
                case 0: 
                case 1: {
                    if (commandCode == 1) {
                        this.m_Matrix.setDotXYOn(x, y);
                        break;
                    }
                    this.m_Matrix.setDotXYOff(x, y);
                    break;
                }
                case 2: {
                    if (x > 63) {
                        x -= 128;
                    }
                    if (y > 15) {
                        y -= 32;
                    }
                    this.m_Matrix.scroll(x, y);
                    break;
                }
                case 3: {
                    this.m_Matrix.clrScreen();
                    break;
                }
                case 4: {
                    this.m_Matrix.lightScreen();
                    break;
                }
            }
            this.repaint();
        }
    }
}

