/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.datamatrix.detector;

import com.google.zxing.NotFoundException;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.Collections;
import com.google.zxing.common.Comparator;
import com.google.zxing.common.DetectorResult;
import com.google.zxing.common.GridSampler;
import com.google.zxing.common.detector.WhiteRectangleDetector;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class Detector {
    private static final Integer[] INTEGERS = new Integer[]{new Integer(0), new Integer(1), new Integer(2), new Integer(3), new Integer(4)};
    private final BitMatrix image;
    private final WhiteRectangleDetector rectangleDetector;

    public Detector(BitMatrix image) throws NotFoundException {
        this.image = image;
        this.rectangleDetector = new WhiteRectangleDetector(image);
    }

    public DetectorResult detect() throws NotFoundException {
        BitMatrix bits;
        ResultPoint correctedTopRight;
        ResultPoint[] cornerPoints = this.rectangleDetector.detect();
        ResultPoint pointA = cornerPoints[0];
        ResultPoint pointB = cornerPoints[1];
        ResultPoint pointC = cornerPoints[2];
        ResultPoint pointD = cornerPoints[3];
        Vector<ResultPointsAndTransitions> transitions = new Vector<ResultPointsAndTransitions>(4);
        transitions.addElement(this.transitionsBetween(pointA, pointB));
        transitions.addElement(this.transitionsBetween(pointA, pointC));
        transitions.addElement(this.transitionsBetween(pointB, pointD));
        transitions.addElement(this.transitionsBetween(pointC, pointD));
        Collections.insertionSort(transitions, new ResultPointsAndTransitionsComparator());
        ResultPointsAndTransitions lSideOne = (ResultPointsAndTransitions)transitions.elementAt(0);
        ResultPointsAndTransitions lSideTwo = (ResultPointsAndTransitions)transitions.elementAt(1);
        Hashtable pointCount = new Hashtable();
        Detector.increment(pointCount, lSideOne.getFrom());
        Detector.increment(pointCount, lSideOne.getTo());
        Detector.increment(pointCount, lSideTwo.getFrom());
        Detector.increment(pointCount, lSideTwo.getTo());
        ResultPoint maybeTopLeft = null;
        ResultPoint bottomLeft = null;
        ResultPoint maybeBottomRight = null;
        Enumeration points = pointCount.keys();
        while (points.hasMoreElements()) {
            ResultPoint point = (ResultPoint)points.nextElement();
            Integer value = (Integer)pointCount.get(point);
            if (value == 2) {
                bottomLeft = point;
                continue;
            }
            if (maybeTopLeft == null) {
                maybeTopLeft = point;
                continue;
            }
            maybeBottomRight = point;
        }
        if (maybeTopLeft == null || bottomLeft == null || maybeBottomRight == null) {
            throw NotFoundException.getNotFoundInstance();
        }
        ResultPoint[] corners = new ResultPoint[]{maybeTopLeft, bottomLeft, maybeBottomRight};
        ResultPoint.orderBestPatterns(corners);
        ResultPoint bottomRight = corners[0];
        bottomLeft = corners[1];
        ResultPoint topLeft = corners[2];
        ResultPoint topRight = !pointCount.containsKey(pointA) ? pointA : (!pointCount.containsKey(pointB) ? pointB : (!pointCount.containsKey(pointC) ? pointC : pointD));
        int dimensionTop = this.transitionsBetween(topLeft, topRight).getTransitions();
        int dimensionRight = this.transitionsBetween(bottomRight, topRight).getTransitions();
        if ((dimensionTop & 1) == 1) {
            ++dimensionTop;
        }
        dimensionTop += 2;
        if ((dimensionRight & 1) == 1) {
            ++dimensionRight;
        }
        if (4 * dimensionTop >= 7 * (dimensionRight += 2) || 4 * dimensionRight >= 7 * dimensionTop) {
            correctedTopRight = this.correctTopRightRectangular(bottomLeft, bottomRight, topLeft, topRight, dimensionTop, dimensionRight);
            if (correctedTopRight == null) {
                correctedTopRight = topRight;
            }
            dimensionTop = this.transitionsBetween(topLeft, correctedTopRight).getTransitions();
            dimensionRight = this.transitionsBetween(bottomRight, correctedTopRight).getTransitions();
            if ((dimensionTop & 1) == 1) {
                ++dimensionTop;
            }
            if ((dimensionRight & 1) == 1) {
                ++dimensionRight;
            }
            bits = Detector.sampleGrid(this.image, topLeft, bottomLeft, bottomRight, correctedTopRight, dimensionTop, dimensionRight);
        } else {
            int dimension = Math.min(dimensionRight, dimensionTop);
            correctedTopRight = this.correctTopRight(bottomLeft, bottomRight, topLeft, topRight, dimension);
            if (correctedTopRight == null) {
                correctedTopRight = topRight;
            }
            int dimensionCorrected = Math.max(this.transitionsBetween(topLeft, correctedTopRight).getTransitions(), this.transitionsBetween(bottomRight, correctedTopRight).getTransitions());
            if ((++dimensionCorrected & 1) == 1) {
                ++dimensionCorrected;
            }
            bits = Detector.sampleGrid(this.image, topLeft, bottomLeft, bottomRight, correctedTopRight, dimensionCorrected, dimensionCorrected);
        }
        return new DetectorResult(bits, new ResultPoint[]{topLeft, bottomLeft, bottomRight, correctedTopRight});
    }

    private ResultPoint correctTopRightRectangular(ResultPoint bottomLeft, ResultPoint bottomRight, ResultPoint topLeft, ResultPoint topRight, int dimensionTop, int dimensionRight) {
        int l2;
        float corr = (float)Detector.distance(bottomLeft, bottomRight) / (float)dimensionTop;
        int norm = Detector.distance(topLeft, topRight);
        float cos = (topRight.getX() - topLeft.getX()) / (float)norm;
        float sin = (topRight.getY() - topLeft.getY()) / (float)norm;
        ResultPoint c1 = new ResultPoint(topRight.getX() + corr * cos, topRight.getY() + corr * sin);
        corr = (float)Detector.distance(bottomLeft, topLeft) / (float)dimensionRight;
        norm = Detector.distance(bottomRight, topRight);
        cos = (topRight.getX() - bottomRight.getX()) / (float)norm;
        sin = (topRight.getY() - bottomRight.getY()) / (float)norm;
        ResultPoint c2 = new ResultPoint(topRight.getX() + corr * cos, topRight.getY() + corr * sin);
        if (!this.isValid(c1)) {
            if (this.isValid(c2)) {
                return c2;
            }
            return null;
        }
        if (!this.isValid(c2)) {
            return c1;
        }
        int l1 = Math.abs(dimensionTop - this.transitionsBetween(topLeft, c1).getTransitions()) + Math.abs(dimensionRight - this.transitionsBetween(bottomRight, c1).getTransitions());
        if (l1 <= (l2 = Math.abs(dimensionTop - this.transitionsBetween(topLeft, c2).getTransitions()) + Math.abs(dimensionRight - this.transitionsBetween(bottomRight, c2).getTransitions()))) {
            return c1;
        }
        return c2;
    }

    private ResultPoint correctTopRight(ResultPoint bottomLeft, ResultPoint bottomRight, ResultPoint topLeft, ResultPoint topRight, int dimension) {
        int l2;
        float corr = (float)Detector.distance(bottomLeft, bottomRight) / (float)dimension;
        int norm = Detector.distance(topLeft, topRight);
        float cos = (topRight.getX() - topLeft.getX()) / (float)norm;
        float sin = (topRight.getY() - topLeft.getY()) / (float)norm;
        ResultPoint c1 = new ResultPoint(topRight.getX() + corr * cos, topRight.getY() + corr * sin);
        corr = (float)Detector.distance(bottomLeft, bottomRight) / (float)dimension;
        norm = Detector.distance(bottomRight, topRight);
        cos = (topRight.getX() - bottomRight.getX()) / (float)norm;
        sin = (topRight.getY() - bottomRight.getY()) / (float)norm;
        ResultPoint c2 = new ResultPoint(topRight.getX() + corr * cos, topRight.getY() + corr * sin);
        if (!this.isValid(c1)) {
            if (this.isValid(c2)) {
                return c2;
            }
            return null;
        }
        if (!this.isValid(c2)) {
            return c1;
        }
        int l1 = Math.abs(this.transitionsBetween(topLeft, c1).getTransitions() - this.transitionsBetween(bottomRight, c1).getTransitions());
        return l1 <= (l2 = Math.abs(this.transitionsBetween(topLeft, c2).getTransitions() - this.transitionsBetween(bottomRight, c2).getTransitions())) ? c1 : c2;
    }

    private boolean isValid(ResultPoint p) {
        return p.getX() >= 0.0f && p.getX() < (float)this.image.width && p.getY() > 0.0f && p.getY() < (float)this.image.height;
    }

    private static int round(float d) {
        return (int)(d + 0.5f);
    }

    private static int distance(ResultPoint a, ResultPoint b) {
        return Detector.round((float)Math.sqrt((a.getX() - b.getX()) * (a.getX() - b.getX()) + (a.getY() - b.getY()) * (a.getY() - b.getY())));
    }

    private static void increment(Hashtable table, ResultPoint key) {
        Integer value = (Integer)table.get(key);
        table.put(key, value == null ? INTEGERS[1] : INTEGERS[value + 1]);
    }

    private static BitMatrix sampleGrid(BitMatrix image, ResultPoint topLeft, ResultPoint bottomLeft, ResultPoint bottomRight, ResultPoint topRight, int dimensionX, int dimensionY) throws NotFoundException {
        GridSampler sampler = GridSampler.getInstance();
        return sampler.sampleGrid(image, dimensionX, dimensionY, 0.5f, 0.5f, (float)dimensionX - 0.5f, 0.5f, (float)dimensionX - 0.5f, (float)dimensionY - 0.5f, 0.5f, (float)dimensionY - 0.5f, topLeft.getX(), topLeft.getY(), topRight.getX(), topRight.getY(), bottomRight.getX(), bottomRight.getY(), bottomLeft.getX(), bottomLeft.getY());
    }

    private ResultPointsAndTransitions transitionsBetween(ResultPoint from, ResultPoint to) {
        boolean steep;
        int fromX = (int)from.getX();
        int fromY = (int)from.getY();
        int toX = (int)to.getX();
        int toY = (int)to.getY();
        boolean bl = steep = Math.abs(toY - fromY) > Math.abs(toX - fromX);
        if (steep) {
            int temp = fromX;
            fromX = fromY;
            fromY = temp;
            temp = toX;
            toX = toY;
            toY = temp;
        }
        int dx = Math.abs(toX - fromX);
        int dy = Math.abs(toY - fromY);
        int error = -dx >> 1;
        int ystep = fromY < toY ? 1 : -1;
        int xstep = fromX < toX ? 1 : -1;
        int transitions = 0;
        boolean inBlack = this.image.get(steep ? fromY : fromX, steep ? fromX : fromY);
        int y = fromY;
        for (int x = fromX; x != toX; x += xstep) {
            boolean isBlack = this.image.get(steep ? y : x, steep ? x : y);
            if (isBlack != inBlack) {
                ++transitions;
                inBlack = isBlack;
            }
            if ((error += dy) <= 0) continue;
            if (y == toY) break;
            y += ystep;
            error -= dx;
        }
        return new ResultPointsAndTransitions(from, to, transitions);
    }

    private static class ResultPointsAndTransitionsComparator
    implements Comparator {
        private ResultPointsAndTransitionsComparator() {
        }

        public int compare(Object o1, Object o2) {
            return ((ResultPointsAndTransitions)o1).getTransitions() - ((ResultPointsAndTransitions)o2).getTransitions();
        }
    }

    private static class ResultPointsAndTransitions {
        private final ResultPoint from;
        private final ResultPoint to;
        private final int transitions;

        private ResultPointsAndTransitions(ResultPoint from, ResultPoint to, int transitions) {
            this.from = from;
            this.to = to;
            this.transitions = transitions;
        }

        public ResultPoint getFrom() {
            return this.from;
        }

        public ResultPoint getTo() {
            return this.to;
        }

        public int getTransitions() {
            return this.transitions;
        }

        public String toString() {
            return this.from + "/" + this.to + '/' + this.transitions;
        }
    }
}

