/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.gpio;

import java.util.EnumSet;

public enum PinState {
    LOW(0, "LOW"),
    HIGH(1, "HIGH");

    private final int value;
    private final String name;

    private PinState(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public boolean isHigh() {
        return this == HIGH;
    }

    public boolean isLow() {
        return this == LOW;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public static PinState getState(int state) {
        for (PinState item : PinState.values()) {
            if (item.getValue() != state) continue;
            return item;
        }
        return null;
    }

    public static PinState getInverseState(PinState state) {
        return state == HIGH ? LOW : HIGH;
    }

    public static PinState getState(boolean state) {
        return state ? HIGH : LOW;
    }

    public static PinState[] allStates() {
        return PinState.values();
    }

    public static EnumSet<PinState> all() {
        return EnumSet.of(HIGH, LOW);
    }
}

