/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.result;

import com.google.zxing.Result;
import com.google.zxing.client.result.ResultParser;
import com.google.zxing.client.result.URIParsedResult;

final class URIResultParser
extends ResultParser {
    private URIResultParser() {
    }

    public static URIParsedResult parse(Result result) {
        String rawText = result.getText();
        if (rawText != null && rawText.startsWith("URL:")) {
            rawText = rawText.substring(4);
        }
        if (rawText != null) {
            rawText = rawText.trim();
        }
        if (!URIResultParser.isBasicallyValidURI(rawText)) {
            return null;
        }
        return new URIParsedResult(rawText, null);
    }

    static boolean isBasicallyValidURI(String uri) {
        block8: {
            if (uri == null || uri.indexOf(32) >= 0 || uri.indexOf(10) >= 0) {
                return false;
            }
            int period = uri.indexOf(46);
            if (period >= uri.length() - 2) {
                return false;
            }
            int colon = uri.indexOf(58);
            if (period < 0 && colon < 0) {
                return false;
            }
            if (colon < 0) break block8;
            if (period < 0 || period > colon) {
                for (int i = 0; i < colon; ++i) {
                    char c = uri.charAt(i);
                    if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') continue;
                    return false;
                }
            } else {
                if (colon >= uri.length() - 2) {
                    return false;
                }
                for (int i = colon + 1; i < colon + 3; ++i) {
                    char c = uri.charAt(i);
                    if (c >= '0' && c <= '9') continue;
                    return false;
                }
            }
        }
        return true;
    }
}

