/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.component.button.impl;

import com.pi4j.component.button.Button;
import com.pi4j.component.button.ButtonBase;
import com.pi4j.component.button.ButtonState;
import com.pi4j.component.button.ButtonStateChangeEvent;
import com.pi4j.io.gpio.GpioPinDigitalInput;
import com.pi4j.io.gpio.PinState;
import com.pi4j.io.gpio.event.GpioPinDigitalStateChangeEvent;
import com.pi4j.io.gpio.event.GpioPinListener;
import com.pi4j.io.gpio.event.GpioPinListenerDigital;

public class GpioButtonComponent
extends ButtonBase {
    private GpioPinDigitalInput pin = null;
    private PinState releasedState = PinState.LOW;
    private PinState pressedState = PinState.HIGH;
    private final Button buttonComponent = this;
    private GpioPinListenerDigital pinListener = new GpioPinListenerDigital(){

        public void handleGpioPinDigitalStateChangeEvent(GpioPinDigitalStateChangeEvent event) {
            if (event.getState() == GpioButtonComponent.this.pressedState) {
                GpioButtonComponent.this.notifyListeners(new ButtonStateChangeEvent(GpioButtonComponent.this.buttonComponent, ButtonState.RELEASED, ButtonState.PRESSED));
            } else if (event.getState() == GpioButtonComponent.this.releasedState) {
                GpioButtonComponent.this.notifyListeners(new ButtonStateChangeEvent(GpioButtonComponent.this.buttonComponent, ButtonState.PRESSED, ButtonState.RELEASED));
            }
        }
    };

    public GpioButtonComponent(GpioPinDigitalInput pin, PinState releasedState, PinState pressedState) {
        this.pin = pin;
        this.pressedState = pressedState;
        this.releasedState = releasedState;
        this.pin.addListener(new GpioPinListener[]{this.pinListener});
    }

    public GpioButtonComponent(GpioPinDigitalInput pin) {
        this.pin = pin;
        this.pin.addListener(new GpioPinListener[]{this.pinListener});
    }

    @Override
    public ButtonState getState() {
        if (this.pin.isState(this.pressedState)) {
            return ButtonState.PRESSED;
        }
        return ButtonState.RELEASED;
    }
}

