/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.component.lcd;

import com.pi4j.component.ComponentBase;
import com.pi4j.component.lcd.LCD;
import com.pi4j.component.lcd.LCDTextAlignment;
import com.pi4j.util.StringUtil;
import java.io.UnsupportedEncodingException;

public abstract class LCDBase
extends ComponentBase
implements LCD {
    @Override
    public abstract int getRowCount();

    @Override
    public abstract int getColumnCount();

    @Override
    public void clear() {
        this.clear(0, 0, this.getColumnCount());
        this.clear(1, 0, this.getColumnCount());
    }

    @Override
    public void clear(int row) {
        this.validateRowIndex(row);
        this.clear(row, 0, this.getColumnCount());
    }

    @Override
    public void clear(int row, int column, int length) {
        int index;
        StringBuilder sb = new StringBuilder(this.getColumnCount());
        for (index = 0; index < this.getRowCount(); ++index) {
            sb.append(" ");
        }
        for (index = 0; index < this.getRowCount(); ++index) {
            this.write(index, 0, sb.toString());
        }
    }

    @Override
    public void setCursorHome() {
        this.setCursorPosition(0);
    }

    @Override
    public void setCursorPosition(int row) {
        this.validateRowIndex(row);
        this.setCursorPosition(row, 0);
    }

    @Override
    public abstract void setCursorPosition(int var1, int var2);

    @Override
    public void write(String data) {
        try {
            this.write(data.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void write(String data, Object ... arguments) {
        this.write(String.format(data, arguments));
    }

    @Override
    public void write(char[] data) {
        for (char c : data) {
            this.write(c);
        }
    }

    @Override
    public void write(byte[] data) {
        for (byte b : data) {
            this.write(b);
        }
    }

    @Override
    public void write(char data) {
        this.write((byte)data);
    }

    @Override
    public abstract void write(byte var1);

    @Override
    public void write(int row, String data) {
        this.write(row, 0, data);
    }

    @Override
    public void write(int row, String data, LCDTextAlignment alignment) {
        int columnIndex = 0;
        if (alignment != LCDTextAlignment.ALIGN_LEFT && data.length() < this.getColumnCount()) {
            int remaining = this.getColumnCount() - data.length();
            if (alignment == LCDTextAlignment.ALIGN_RIGHT) {
                columnIndex = remaining;
            } else if (alignment == LCDTextAlignment.ALIGN_CENTER) {
                columnIndex = remaining / 2;
            }
        }
        this.write(row, columnIndex, data);
    }

    @Override
    public void write(int row, String data, Object ... arguments) {
        this.write(row, 0, data, arguments);
    }

    @Override
    public void write(int row, String data, LCDTextAlignment alignment, Object ... arguments) {
        this.write(row, String.format(data, arguments), alignment);
    }

    @Override
    public void write(int row, char[] data) {
        this.write(row, 0, data);
    }

    @Override
    public void write(int row, byte[] data) {
        this.write(row, 0, data);
    }

    @Override
    public void write(int row, char data) {
        this.write(row, 0, data);
    }

    @Override
    public void write(int row, byte data) {
        this.write(row, 0, data);
    }

    @Override
    public void write(int row, int column, String data) {
        this.validateCoordinates(row, column);
        this.setCursorPosition(row, column);
        this.write(data);
    }

    @Override
    public void write(int row, int column, String data, Object ... arguments) {
        this.validateCoordinates(row, column);
        this.setCursorPosition(row, column);
        this.write(data, arguments);
    }

    @Override
    public void write(int row, int column, char[] data) {
        this.validateCoordinates(row, column);
        this.setCursorPosition(row, column);
        this.write(data);
    }

    @Override
    public void write(int row, int column, byte[] data) {
        this.validateCoordinates(row, column);
        this.setCursorPosition(row, column);
        this.write(data);
    }

    @Override
    public void write(int row, int column, char data) {
        this.validateCoordinates(row, column);
        this.setCursorPosition(row, column);
        this.write(data);
    }

    @Override
    public void write(int row, int column, byte data) {
        this.validateCoordinates(row, column);
        this.setCursorPosition(row, column);
        this.write(data);
    }

    @Override
    public void writeln(int row, String data) {
        this.writeln(row, data, LCDTextAlignment.ALIGN_LEFT);
    }

    @Override
    public void writeln(int row, String data, LCDTextAlignment alignment) {
        String result = data;
        if (data.length() < this.getColumnCount()) {
            if (alignment == LCDTextAlignment.ALIGN_LEFT) {
                result = StringUtil.padRight((String)data, (int)(this.getColumnCount() - data.length()));
            } else if (alignment == LCDTextAlignment.ALIGN_RIGHT) {
                result = StringUtil.padLeft((String)data, (int)(this.getColumnCount() - data.length()));
            } else if (alignment == LCDTextAlignment.ALIGN_CENTER) {
                result = StringUtil.padCenter((String)data, (int)this.getColumnCount());
            }
        }
        this.write(row, 0, result);
    }

    @Override
    public void writeln(int row, String data, Object ... arguments) {
        this.writeln(row, String.format(data, arguments));
    }

    @Override
    public void writeln(int row, String data, LCDTextAlignment alignment, Object ... arguments) {
        this.writeln(row, String.format(data, arguments), alignment);
    }

    protected void validateCoordinates(int row, int column) {
        this.validateRowIndex(row);
        this.validateColumnIndex(column);
    }

    protected void validateRowIndex(int row) {
        if (row >= this.getRowCount() || row < 0) {
            throw new RuntimeException("Invalid row index.");
        }
    }

    protected void validateColumnIndex(int column) {
        if (column >= this.getColumnCount() || column < 0) {
            throw new RuntimeException("Invalid column index.");
        }
    }
}

