/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.component.motor.impl;

import com.pi4j.component.motor.MotorState;
import com.pi4j.component.motor.StepperMotorBase;
import com.pi4j.io.gpio.GpioPinDigitalOutput;
import com.pi4j.io.gpio.PinState;

public class GpioStepperMotorComponent
extends StepperMotorBase {
    private GpioPinDigitalOutput[] pins;
    private PinState onState = PinState.HIGH;
    private PinState offState = PinState.LOW;
    private MotorState currentState = MotorState.STOP;
    private GpioStepperMotorControl controlThread = new GpioStepperMotorControl();
    private int sequenceIndex = 0;

    public GpioStepperMotorComponent(GpioPinDigitalOutput[] pins, PinState onState, PinState offState) {
        this.pins = pins;
        this.onState = onState;
        this.offState = offState;
    }

    public GpioStepperMotorComponent(GpioPinDigitalOutput[] pins) {
        this.pins = pins;
    }

    @Override
    public MotorState getState() {
        return this.currentState;
    }

    @Override
    public void setState(MotorState state) {
        switch (state) {
            case STOP: {
                this.currentState = MotorState.STOP;
                for (GpioPinDigitalOutput pin : this.pins) {
                    pin.setState(this.offState);
                }
                break;
            }
            case FORWARD: {
                this.currentState = MotorState.FORWARD;
                if (this.controlThread.isAlive()) break;
                this.controlThread = new GpioStepperMotorControl();
                this.controlThread.start();
                break;
            }
            case REVERSE: {
                this.currentState = MotorState.REVERSE;
                if (this.controlThread.isAlive()) break;
                this.controlThread = new GpioStepperMotorControl();
                this.controlThread.start();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Cannot set motor state: " + state.toString());
            }
        }
    }

    @Override
    public void step(long steps) {
        if (steps == 0L) {
            this.setState(MotorState.STOP);
            return;
        }
        if (steps > 0L) {
            for (long index = 1L; index <= steps; ++index) {
                this.doStep(true);
            }
        } else {
            for (long index = steps; index < 0L; ++index) {
                this.doStep(false);
            }
        }
        this.stop();
    }

    private void doStep(boolean forward) {
        this.sequenceIndex = forward ? ++this.sequenceIndex : --this.sequenceIndex;
        if (this.sequenceIndex >= this.stepSequence.length) {
            this.sequenceIndex = 0;
        } else if (this.sequenceIndex < 0) {
            this.sequenceIndex = this.stepSequence.length - 1;
        }
        for (int pinIndex = 0; pinIndex < this.pins.length; ++pinIndex) {
            double nib = Math.pow(2.0, pinIndex);
            if ((this.stepSequence[this.sequenceIndex] & (int)nib) > 0) {
                this.pins[pinIndex].setState(this.onState);
                continue;
            }
            this.pins[pinIndex].setState(this.offState);
        }
        try {
            Thread.sleep(this.stepIntervalMilliseconds, this.stepIntervalNanoseconds);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private class GpioStepperMotorControl
    extends Thread {
        private GpioStepperMotorControl() {
        }

        @Override
        public void run() {
            while (GpioStepperMotorComponent.this.currentState != MotorState.STOP) {
                if (GpioStepperMotorComponent.this.currentState == MotorState.FORWARD) {
                    GpioStepperMotorComponent.this.doStep(true);
                    continue;
                }
                if (GpioStepperMotorComponent.this.currentState != MotorState.REVERSE) continue;
                GpioStepperMotorComponent.this.doStep(false);
            }
            for (GpioPinDigitalOutput pin : GpioStepperMotorComponent.this.pins) {
                pin.setState(GpioStepperMotorComponent.this.offState);
            }
        }
    }
}

