/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.component.potentiometer.microchip.impl;

import com.pi4j.component.ComponentBase;
import com.pi4j.component.potentiometer.microchip.MicrochipPotentiometer;
import com.pi4j.component.potentiometer.microchip.MicrochipPotentiometerChannel;
import com.pi4j.component.potentiometer.microchip.MicrochipPotentiometerDeviceStatus;
import com.pi4j.component.potentiometer.microchip.MicrochipPotentiometerNonVolatileMode;
import com.pi4j.component.potentiometer.microchip.MicrochipPotentiometerTerminalConfiguration;
import com.pi4j.component.potentiometer.microchip.impl.DeviceControllerChannel;
import com.pi4j.component.potentiometer.microchip.impl.DeviceControllerDeviceStatus;
import com.pi4j.component.potentiometer.microchip.impl.DeviceControllerTerminalConfiguration;
import com.pi4j.component.potentiometer.microchip.impl.MicrochipPotentiometerDefaultDeviceControllerFactory;
import com.pi4j.component.potentiometer.microchip.impl.MicrochipPotentiometerDeviceController;
import com.pi4j.component.potentiometer.microchip.impl.MicrochipPotentiometerDeviceControllerFactory;
import com.pi4j.component.potentiometer.microchip.impl.MicrochipPotentiometerDeviceStatusImpl;
import com.pi4j.io.i2c.I2CBus;
import com.pi4j.io.i2c.I2CDevice;
import java.io.IOException;

public abstract class MicrochipPotentiometerBase
extends ComponentBase
implements MicrochipPotentiometer {
    protected static final boolean PIN_NOT_AVAILABLE = true;
    protected static final int INITIALVALUE_LOADED_FROM_EEPROM = 0;
    private MicrochipPotentiometerDeviceController controller;
    private MicrochipPotentiometerChannel channel;
    protected MicrochipPotentiometerNonVolatileMode nonVolatileMode;
    private int currentValue;

    protected MicrochipPotentiometerBase(I2CBus i2cBus, boolean pinA0, boolean pinA1, boolean pinA2, MicrochipPotentiometerChannel channel, MicrochipPotentiometerNonVolatileMode nonVolatileMode, int initialValueForVolatileWipers) throws IOException {
        this(i2cBus, pinA0, pinA1, pinA2, channel, nonVolatileMode, initialValueForVolatileWipers, MicrochipPotentiometerDefaultDeviceControllerFactory.getInstance());
    }

    protected MicrochipPotentiometerBase(I2CBus i2cBus, boolean pinA0, boolean pinA1, boolean pinA2, MicrochipPotentiometerChannel channel, MicrochipPotentiometerNonVolatileMode nonVolatileMode, int initialValueForVolatileWipers, MicrochipPotentiometerDeviceControllerFactory controllerFactory) throws IOException {
        if (i2cBus == null) {
            throw new RuntimeException("Parameter 'i2cBus' must not be null!");
        }
        if (channel == null) {
            throw new RuntimeException("For building a Microchip-potentiometer specifying a channel is mandatory! If the device knows more than one potentiometer/rheostat the channel defines which of them is controlled by this object-instance");
        }
        if (!this.isChannelSupportedByDevice(channel)) {
            throw new RuntimeException("For building a Microchip-potentiometer only channels supported by the underlying device are valid parameters!");
        }
        if (controllerFactory == null) {
            throw new RuntimeException("For building a Microchip-potentiometer providing a controllerFactory is mandatory! Use 'DefaultDeviceControllerFactory.getInstance()'.");
        }
        if (nonVolatileMode == null) {
            throw new RuntimeException("For building a Microchip-potentiometer providing a nonVolatileMode is mandatory!.");
        }
        this.channel = channel;
        this.nonVolatileMode = nonVolatileMode;
        int i2cAddress = MicrochipPotentiometerBase.buildI2CAddress(pinA0, pinA1, pinA2);
        I2CDevice i2cDevice = i2cBus.getDevice(i2cAddress);
        this.controller = controllerFactory.getController(i2cDevice);
        this.initialize(initialValueForVolatileWipers);
    }

    protected void initialize(int initialValueForVolatileWipers) throws IOException {
        if (this.isCapableOfNonVolatileWiper()) {
            this.currentValue = this.controller.getValue(DeviceControllerChannel.valueOf(this.channel), false);
        } else {
            int newInitialValueForVolatileWipers = this.getValueAccordingBoundaries(initialValueForVolatileWipers);
            this.controller.setValue(DeviceControllerChannel.valueOf(this.channel), newInitialValueForVolatileWipers, false);
            this.currentValue = newInitialValueForVolatileWipers;
        }
    }

    @Override
    public MicrochipPotentiometerChannel getChannel() {
        return this.channel;
    }

    @Override
    public abstract boolean isCapableOfNonVolatileWiper();

    @Override
    public abstract MicrochipPotentiometerChannel[] getSupportedChannelsByDevice();

    protected static int buildI2CAddress(boolean pinA0, boolean pinA1, boolean pinA2) {
        int i2cAddress = 40;
        if (pinA0) {
            i2cAddress |= 1;
        }
        if (pinA1) {
            i2cAddress |= 2;
        }
        if (pinA2) {
            i2cAddress |= 4;
        }
        return i2cAddress;
    }

    @Override
    public MicrochipPotentiometerNonVolatileMode getNonVolatileMode() {
        return this.nonVolatileMode;
    }

    protected void setNonVolatileMode(MicrochipPotentiometerNonVolatileMode nonVolatileMode) {
        if (nonVolatileMode == null) {
            throw new RuntimeException("Setting a null-NonVolatileMode is not valid!");
        }
        if (!this.isCapableOfNonVolatileWiper() && nonVolatileMode != MicrochipPotentiometerNonVolatileMode.VOLATILE_ONLY) {
            throw new RuntimeException("This device is not capable of non-volatile wipers. Using another NonVolatileMode than '" + (Object)((Object)MicrochipPotentiometerNonVolatileMode.VOLATILE_ONLY) + "' is not valid!");
        }
        this.nonVolatileMode = nonVolatileMode;
    }

    @Override
    public int updateCacheFromDevice() throws IOException {
        this.currentValue = this.controller.getValue(DeviceControllerChannel.valueOf(this.channel), false);
        return this.currentValue;
    }

    protected int getNonVolatileValue() throws IOException {
        if (!this.isCapableOfNonVolatileWiper()) {
            throw new RuntimeException("This device is not capable of non-volatile wipers!");
        }
        return this.controller.getValue(DeviceControllerChannel.valueOf(this.channel), true);
    }

    @Override
    public int getCurrentValue() throws IOException {
        return this.currentValue;
    }

    private int getValueAccordingBoundaries(int value) {
        int newValue = value < 0 ? 0 : (value > this.getMaxValue() ? this.getMaxValue() : value);
        return newValue;
    }

    @Override
    public void setCurrentValue(int value) throws IOException {
        final int newValue = this.getValueAccordingBoundaries(value);
        this.doWiperAction(new WiperAction(){

            @Override
            public void run(boolean nonVolatile) throws IOException {
                MicrochipPotentiometerBase.this.controller.setValue(DeviceControllerChannel.valueOf(MicrochipPotentiometerBase.this.channel), newValue, nonVolatile);
            }
        });
        if (this.nonVolatileMode == MicrochipPotentiometerNonVolatileMode.NONVOLATILE_ONLY) {
            return;
        }
        this.currentValue = newValue;
    }

    @Override
    public void decrease() throws IOException {
        this.decrease(1);
    }

    @Override
    public void decrease(int steps) throws IOException {
        if (this.currentValue == 0) {
            return;
        }
        if (steps < 0) {
            throw new RuntimeException("Only positive values for parameter 'steps' allowed!");
        }
        if (this.getNonVolatileMode() != MicrochipPotentiometerNonVolatileMode.VOLATILE_ONLY) {
            throw new RuntimeException("'decrease' is only valid for NonVolatileMode.VOLATILE_ONLY!");
        }
        int actualSteps = steps > this.currentValue ? this.currentValue : steps;
        int newValue = this.currentValue - actualSteps;
        if (newValue == 0 || steps > 5) {
            this.setCurrentValue(newValue);
        } else {
            this.controller.decrease(DeviceControllerChannel.valueOf(this.channel), actualSteps);
            this.currentValue = newValue;
        }
    }

    @Override
    public void increase() throws IOException {
        this.increase(1);
    }

    @Override
    public void increase(int steps) throws IOException {
        int maxValue = this.getMaxValue();
        if (this.currentValue == maxValue) {
            return;
        }
        if (steps < 0) {
            throw new RuntimeException("only positive values for parameter 'steps' allowed!");
        }
        if (this.getNonVolatileMode() != MicrochipPotentiometerNonVolatileMode.VOLATILE_ONLY) {
            throw new RuntimeException("'increase' is only valid for NonVolatileMode.VOLATILE_ONLY!");
        }
        int actualSteps = steps + this.currentValue > maxValue ? maxValue - this.currentValue : steps;
        int newValue = this.currentValue + actualSteps;
        if (newValue == maxValue || steps > 5) {
            this.setCurrentValue(newValue);
        } else {
            this.controller.increase(DeviceControllerChannel.valueOf(this.channel), actualSteps);
            this.currentValue = newValue;
        }
    }

    @Override
    public MicrochipPotentiometerDeviceStatus getDeviceStatus() throws IOException {
        DeviceControllerDeviceStatus deviceStatus = this.controller.getDeviceStatus();
        boolean wiperLockActive = this.channel == MicrochipPotentiometerChannel.A ? deviceStatus.isChannelALocked() : deviceStatus.isChannelBLocked();
        return new MicrochipPotentiometerDeviceStatusImpl(deviceStatus.isEepromWriteActive(), deviceStatus.isEepromWriteProtected(), this.channel, wiperLockActive);
    }

    @Override
    public MicrochipPotentiometerTerminalConfiguration getTerminalConfiguration() throws IOException {
        DeviceControllerTerminalConfiguration tcon = this.controller.getTerminalConfiguration(DeviceControllerChannel.valueOf(this.channel));
        return new MicrochipPotentiometerTerminalConfiguration(this.channel, tcon.isChannelEnabled(), tcon.isPinAEnabled(), tcon.isPinWEnabled(), tcon.isPinBEnabled());
    }

    @Override
    public void setTerminalConfiguration(MicrochipPotentiometerTerminalConfiguration terminalConfiguration) throws IOException {
        if (terminalConfiguration == null) {
            throw new RuntimeException("Setting a null-terminalConfiguration is not valid!");
        }
        if (terminalConfiguration.getChannel() != this.channel) {
            throw new RuntimeException("Setting a terminalConfiguration with a channel other than the potentiometer's channel is not valid!");
        }
        DeviceControllerTerminalConfiguration tcon = new DeviceControllerTerminalConfiguration(DeviceControllerChannel.valueOf(this.channel), terminalConfiguration.isChannelEnabled(), terminalConfiguration.isPinAEnabled(), terminalConfiguration.isPinWEnabled(), terminalConfiguration.isPinBEnabled());
        this.controller.setTerminalConfiguration(tcon);
    }

    @Override
    public void setWiperLock(boolean enabled) throws IOException {
        this.controller.setWiperLock(DeviceControllerChannel.valueOf(this.channel), enabled);
    }

    @Override
    public void setWriteProtection(boolean enabled) throws IOException {
        this.controller.setWriteProtection(enabled);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        MicrochipPotentiometerBase other = (MicrochipPotentiometerBase)obj;
        if (this.channel != other.channel) {
            return false;
        }
        return this.controller.equals(other.controller);
    }

    public String toString() {
        StringBuffer result = new StringBuffer(this.getClass().getName());
        result.append("{\n");
        result.append("  channel='").append((Object)this.channel);
        result.append("',\n  controller='").append(this.controller);
        result.append("',\n  nonVolatileMode='").append((Object)this.nonVolatileMode);
        result.append("',\n  currentValue='").append(this.currentValue);
        result.append("'\n}");
        return result.toString();
    }

    private void doWiperAction(WiperAction wiperAction) throws IOException {
        switch (this.nonVolatileMode) {
            case VOLATILE_ONLY: 
            case VOLATILE_AND_NONVOLATILE: {
                wiperAction.run(false);
                break;
            }
        }
        switch (this.nonVolatileMode) {
            case VOLATILE_AND_NONVOLATILE: 
            case NONVOLATILE_ONLY: {
                wiperAction.run(true);
                break;
            }
        }
    }

    @Override
    public boolean isChannelSupportedByDevice(MicrochipPotentiometerChannel channel) {
        if (channel == null) {
            return false;
        }
        for (MicrochipPotentiometerChannel supportedChannel : this.getSupportedChannelsByDevice()) {
            if (channel != supportedChannel) continue;
            return true;
        }
        return false;
    }

    private static interface WiperAction {
        public void run(boolean var1) throws IOException;
    }
}

