/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.component.relay;

import com.pi4j.component.ComponentListener;
import com.pi4j.component.ObserveableComponentBase;
import com.pi4j.component.relay.Relay;
import com.pi4j.component.relay.RelayListener;
import com.pi4j.component.relay.RelayState;
import com.pi4j.component.relay.RelayStateChangeEvent;

public abstract class RelayBase
extends ObserveableComponentBase
implements Relay {
    public static final int DEFAULT_PULSE_MILLISECONDS = 500;

    @Override
    public void open() {
        this.setState(RelayState.OPEN);
    }

    @Override
    public void close() {
        this.setState(RelayState.CLOSED);
    }

    @Override
    public boolean isOpen() {
        return this.getState() == RelayState.OPEN;
    }

    @Override
    public boolean isClosed() {
        return this.getState() == RelayState.CLOSED;
    }

    @Override
    public abstract RelayState getState();

    @Override
    public abstract void setState(RelayState var1);

    @Override
    public void pulse() {
        this.pulse(500);
    }

    @Override
    public void pulse(int milliseconds) {
        this.close();
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        this.open();
    }

    @Override
    public void toggle() {
        if (this.isOpen()) {
            this.close();
        } else {
            this.open();
        }
    }

    @Override
    public boolean isState(RelayState state) {
        return this.getState().equals((Object)state);
    }

    @Override
    public void addListener(RelayListener ... listener) {
        super.addListener(listener);
    }

    @Override
    public synchronized void removeListener(RelayListener ... listener) {
        super.removeListener(listener);
    }

    protected synchronized void notifyListeners(RelayStateChangeEvent event) {
        for (ComponentListener listener : this.listeners) {
            ((RelayListener)listener).onStateChange(event);
        }
    }
}

