/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.device.fireplace.impl;

import com.pi4j.component.relay.Relay;
import com.pi4j.component.relay.RelayListener;
import com.pi4j.component.relay.RelayState;
import com.pi4j.component.relay.RelayStateChangeEvent;
import com.pi4j.component.sensor.Sensor;
import com.pi4j.component.sensor.SensorListener;
import com.pi4j.component.sensor.SensorState;
import com.pi4j.component.sensor.SensorStateChangeEvent;
import com.pi4j.device.fireplace.FireplaceBase;
import com.pi4j.device.fireplace.FireplacePilotLightEvent;
import com.pi4j.device.fireplace.FireplacePilotLightException;
import com.pi4j.device.fireplace.FireplaceState;
import com.pi4j.device.fireplace.FireplaceStateChangeEvent;

public class FireplaceDevice
extends FireplaceBase {
    protected final Relay fireplaceControlRelay;
    protected final RelayState fireplaceOnRelayState;
    protected final Sensor pilotLightSensor;
    protected final SensorState pilotLightOnState;

    public FireplaceDevice(Relay fireplaceControlRelay, Sensor pilotLightSensor) {
        this(fireplaceControlRelay, RelayState.CLOSED, pilotLightSensor, SensorState.CLOSED);
    }

    public FireplaceDevice(Relay fireplaceControlRelay, RelayState fireplaceOnRelayState) {
        this(fireplaceControlRelay, fireplaceOnRelayState, null, SensorState.CLOSED);
    }

    public FireplaceDevice(Relay fireplaceControlRelay) {
        this(fireplaceControlRelay, RelayState.CLOSED, null, SensorState.CLOSED);
    }

    public FireplaceDevice(Relay fireplaceControlRelay, final RelayState fireplaceOnRelayState, final Sensor pilotLightSensor, final SensorState pilotLightOnState) {
        this.fireplaceControlRelay = fireplaceControlRelay;
        this.fireplaceOnRelayState = fireplaceOnRelayState;
        this.pilotLightSensor = pilotLightSensor;
        this.pilotLightOnState = pilotLightOnState;
        fireplaceControlRelay.addListener(new RelayListener(){

            @Override
            public void onStateChange(RelayStateChangeEvent event) {
                if (event.getNewState() == fireplaceOnRelayState) {
                    FireplaceDevice.this.notifyListeners(new FireplaceStateChangeEvent(FireplaceDevice.this, FireplaceState.OFF, FireplaceState.ON));
                } else {
                    FireplaceDevice.this.notifyListeners(new FireplaceStateChangeEvent(FireplaceDevice.this, FireplaceState.ON, FireplaceState.OFF));
                }
            }
        });
        if (pilotLightSensor != null) {
            pilotLightSensor.addListener(new SensorListener(){

                @Override
                public void onStateChange(SensorStateChangeEvent event) {
                    if (!pilotLightSensor.isState(pilotLightOnState)) {
                        FireplaceDevice.this.off();
                    }
                    FireplaceDevice.this.notifyListeners(new FireplacePilotLightEvent(FireplaceDevice.this, FireplaceDevice.this.isPilotLightOn()));
                }
            });
        }
    }

    @Override
    public FireplaceState getState() {
        if (this.fireplaceControlRelay.isState(this.fireplaceOnRelayState)) {
            return FireplaceState.ON;
        }
        return FireplaceState.OFF;
    }

    @Override
    public void setState(FireplaceState state) throws FireplacePilotLightException {
        if (state == FireplaceState.OFF) {
            if (this.fireplaceControlRelay.isState(this.fireplaceOnRelayState)) {
                this.fireplaceControlRelay.toggle();
            }
        } else {
            if (this.pilotLightSensor != null && !this.isPilotLightOn()) {
                throw new FireplacePilotLightException();
            }
            if (!this.fireplaceControlRelay.isState(this.fireplaceOnRelayState)) {
                this.fireplaceControlRelay.setState(this.fireplaceOnRelayState);
            }
        }
    }

    @Override
    public boolean isPilotLightOn() {
        if (this.pilotLightSensor == null) {
            return false;
        }
        return this.pilotLightSensor.isState(this.pilotLightOnState);
    }

    @Override
    public boolean isPilotLightOff() {
        return !this.isPilotLightOn();
    }
}

