/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.gpio.extension.mcp;

import com.pi4j.io.gpio.GpioProvider;
import com.pi4j.io.gpio.GpioProviderBase;
import com.pi4j.io.gpio.Pin;
import com.pi4j.io.spi.SpiChannel;
import com.pi4j.io.spi.SpiDevice;
import com.pi4j.io.spi.SpiFactory;
import java.io.IOException;

public class MCP3008GpioProvider
extends GpioProviderBase
implements GpioProvider {
    public static final String NAME = "com.pi4j.gpio.extension.mcp.MCP3008GpioProvider";
    public static final String DESCRIPTION = "MCP3008 GPIO Provider";
    public static final int INVALID_VALUE = -1;
    private final SpiDevice spiDevice;

    public MCP3008GpioProvider(SpiChannel spiChannel) throws IOException {
        this.spiDevice = SpiFactory.getInstance((SpiChannel)spiChannel);
    }

    public String getName() {
        return NAME;
    }

    public double getValue(Pin pin) {
        super.getValue(pin);
        return this.isInitiated() ? (double)this.readAnalog(this.toCommand((short)pin.getAddress())) : -1.0;
    }

    private short toCommand(short channel) {
        short command = (short)(channel + 8 << 4);
        return command;
    }

    private boolean isInitiated() {
        return this.spiDevice != null;
    }

    private int readAnalog(short channelCommand) {
        short[] result;
        short[] data = new short[]{1, channelCommand, 0};
        try {
            result = this.spiDevice.write(data);
        }
        catch (IOException e) {
            return -1;
        }
        int analogValue = ((result[1] & 3) << 8) + result[2];
        return analogValue;
    }
}

