/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.gpio.extension.mcp;

import com.pi4j.io.gpio.GpioProviderBase;
import com.pi4j.io.gpio.Pin;
import com.pi4j.io.i2c.I2CBus;
import com.pi4j.io.i2c.I2CDevice;
import com.pi4j.io.i2c.I2CFactory;
import java.io.IOException;

public class MCP4725GpioProvider
extends GpioProviderBase {
    public static final String NAME = "com.pi4j.gpio.extension.mcp.MCP4725GpioProvider";
    public static final String DESCRIPTION = "MCP4725 GPIO Provider";
    private boolean i2cBusOwner = false;
    private final I2CBus bus;
    private final I2CDevice device;
    public static final int MCP4725_ADDRESS_1 = 98;
    public static final int MCP4725_ADDRESS_2 = 99;
    private static final int MCP4725_REG_WRITEDAC = 64;
    private static final int MCP4725_REG_WRITEDAC_EEPROM = 96;

    public MCP4725GpioProvider(int busNumber, int address) throws IOException {
        this(I2CFactory.getInstance((int)busNumber), address);
        this.i2cBusOwner = true;
    }

    public MCP4725GpioProvider(I2CBus bus, int address) throws IOException {
        this.bus = bus;
        this.device = bus.getDevice(address);
        this.resetOutput();
    }

    private void resetOutput() {
        try {
            byte[] packet = new byte[]{64, 0, 0};
            this.device.write(packet, 0, 3);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to reset DAC output.", e);
        }
    }

    public void setValue(Pin pin, double percentage) {
        super.setValue(pin, percentage);
        int value = (int)(4095.0 * percentage);
        try {
            byte[] packet = new byte[]{64, (byte)(value >> 4), (byte)(value << 4)};
            this.device.write(packet, 0, 3);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to write DAC output value.", e);
        }
    }

    public String getName() {
        return NAME;
    }

    public void shutdown() {
        if (this.isShutdown()) {
            return;
        }
        super.shutdown();
        try {
            this.resetOutput();
            if (this.i2cBusOwner) {
                this.bus.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

