/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.temperature;

import com.pi4j.temperature.TemperatureScale;

public class TemperatureConversion {
    public static final double ABSOLUTE_ZERO_CELSIUS = -273.15;
    public static final double ABSOLUTE_ZERO_FARENHEIT = -459.67;
    public static final double ABSOLUTE_ZERO_KELVIN = 0.0;
    public static final double ABSOLUTE_ZERO_RANKINE = 0.0;

    public static double convert(TemperatureScale from, TemperatureScale to, double temperature) {
        switch (from) {
            case FARENHEIT: {
                return TemperatureConversion.convertFromFarenheit(to, temperature);
            }
            case CELSIUS: {
                return TemperatureConversion.convertFromCelsius(to, temperature);
            }
            case KELVIN: {
                return TemperatureConversion.convertFromKelvin(to, temperature);
            }
            case RANKINE: {
                return TemperatureConversion.convertFromRankine(to, temperature);
            }
        }
        throw new RuntimeException("Invalid termpature conversion");
    }

    public static double convertFromFarenheit(TemperatureScale to, double temperature) {
        switch (to) {
            case FARENHEIT: {
                return temperature;
            }
            case CELSIUS: {
                return TemperatureConversion.convertFarenheitToCelsius(temperature);
            }
            case KELVIN: {
                return TemperatureConversion.convertFarenheitToKelvin(temperature);
            }
            case RANKINE: {
                return TemperatureConversion.convertFarenheitToRankine(temperature);
            }
        }
        throw new RuntimeException("Invalid termpature conversion");
    }

    public static double convertToFarenheit(TemperatureScale from, double temperature) {
        switch (from) {
            case FARENHEIT: {
                return temperature;
            }
            case CELSIUS: {
                return TemperatureConversion.convertCelsiusToFarenheit(temperature);
            }
            case KELVIN: {
                return TemperatureConversion.convertKelvinToFarenheit(temperature);
            }
            case RANKINE: {
                return TemperatureConversion.convertRankineToFarenheit(temperature);
            }
        }
        throw new RuntimeException("Invalid termpature conversion");
    }

    public static double convertFromCelsius(TemperatureScale to, double temperature) {
        switch (to) {
            case FARENHEIT: {
                return TemperatureConversion.convertCelsiusToFarenheit(temperature);
            }
            case CELSIUS: {
                return temperature;
            }
            case KELVIN: {
                return TemperatureConversion.convertCelsiusToKelvin(temperature);
            }
            case RANKINE: {
                return TemperatureConversion.convertCelsiusToRankine(temperature);
            }
        }
        throw new RuntimeException("Invalid termpature conversion");
    }

    public static double convertToCelsius(TemperatureScale from, double temperature) {
        switch (from) {
            case FARENHEIT: {
                return TemperatureConversion.convertFarenheitToCelsius(temperature);
            }
            case CELSIUS: {
                return temperature;
            }
            case KELVIN: {
                return TemperatureConversion.convertKelvinToCelsius(temperature);
            }
            case RANKINE: {
                return TemperatureConversion.convertRankineToCelsius(temperature);
            }
        }
        throw new RuntimeException("Invalid termpature conversion");
    }

    public static double convertFromKelvin(TemperatureScale to, double temperature) {
        switch (to) {
            case FARENHEIT: {
                return TemperatureConversion.convertKelvinToFarenheit(temperature);
            }
            case CELSIUS: {
                return TemperatureConversion.convertKelvinToCelsius(temperature);
            }
            case KELVIN: {
                return temperature;
            }
            case RANKINE: {
                return TemperatureConversion.convertKelvinToRankine(temperature);
            }
        }
        throw new RuntimeException("Invalid termpature conversion");
    }

    public static double convertToKelvin(TemperatureScale from, double temperature) {
        switch (from) {
            case FARENHEIT: {
                return TemperatureConversion.convertFarenheitToKelvin(temperature);
            }
            case CELSIUS: {
                return TemperatureConversion.convertCelsiusToKelvin(temperature);
            }
            case KELVIN: {
                return temperature;
            }
            case RANKINE: {
                return TemperatureConversion.convertRankineToKelvin(temperature);
            }
        }
        throw new RuntimeException("Invalid termpature conversion");
    }

    public static double convertFromRankine(TemperatureScale to, double temperature) {
        switch (to) {
            case FARENHEIT: {
                return TemperatureConversion.convertRankineToFarenheit(temperature);
            }
            case CELSIUS: {
                return TemperatureConversion.convertRankineToCelsius(temperature);
            }
            case KELVIN: {
                return TemperatureConversion.convertRankineToKelvin(temperature);
            }
            case RANKINE: {
                return temperature;
            }
        }
        throw new RuntimeException("Invalid termpature conversion");
    }

    public static double convertToRankine(TemperatureScale from, double temperature) {
        switch (from) {
            case FARENHEIT: {
                return TemperatureConversion.convertFarenheitToRankine(temperature);
            }
            case CELSIUS: {
                return TemperatureConversion.convertCelsiusToRankine(temperature);
            }
            case KELVIN: {
                return TemperatureConversion.convertKelvinToRankine(temperature);
            }
            case RANKINE: {
                return temperature;
            }
        }
        throw new RuntimeException("Invalid termpature conversion");
    }

    public static double convertFarenheitToCelsius(double temperature) {
        return (temperature - 32.0) * 5.0 / 9.0;
    }

    public static double convertFarenheitToKelvin(double temperature) {
        return (temperature + 459.67) * 5.0 / 9.0;
    }

    public static double convertFarenheitToRankine(double temperature) {
        return temperature + 459.67;
    }

    public static double convertCelsiusToFarenheit(double temperature) {
        return temperature * 9.0 / 5.0 + 32.0;
    }

    public static double convertCelsiusToKelvin(double temperature) {
        return temperature - -273.15;
    }

    public static double convertCelsiusToRankine(double temperature) {
        return (temperature - -273.15) * 9.0 / 5.0;
    }

    public static double convertKelvinToCelsius(double temperature) {
        return temperature + -273.15;
    }

    public static double convertKelvinToFarenheit(double temperature) {
        return temperature * 9.0 / 5.0 - 459.67;
    }

    public static double convertKelvinToRankine(double temperature) {
        return temperature * 9.0 / 5.0;
    }

    public static double convertRankineToFarenheit(double temperature) {
        return temperature - 459.67;
    }

    public static double convertRankineToCelsius(double temperature) {
        return (temperature - 491.67) * 5.0 / 9.0;
    }

    public static double convertRankineToKelvin(double temperature) {
        return temperature * 5.0 / 9.0;
    }
}

