/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.component;

import com.pi4j.component.Component;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class ComponentBase
implements Component {
    private String name = null;
    private Object tag = null;
    private final Map<String, String> properties = new ConcurrentHashMap<String, String>();

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setTag(Object tag) {
        this.tag = tag;
    }

    @Override
    public Object getTag() {
        return this.tag;
    }

    @Override
    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    @Override
    public boolean hasProperty(String key) {
        return this.properties.containsKey(key);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        if (this.properties.containsKey(key)) {
            if (this.properties.get(key) == null || this.properties.get(key).isEmpty()) {
                return defaultValue;
            }
            return this.properties.get(key);
        }
        return defaultValue;
    }

    @Override
    public String getProperty(String key) {
        return this.getProperty(key, null);
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public void removeProperty(String key) {
        if (this.properties.containsKey(key)) {
            this.properties.remove(key);
        }
    }

    @Override
    public void clearProperties() {
        this.properties.clear();
    }
}

