/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.component.button;

import com.pi4j.component.ComponentListener;
import com.pi4j.component.ObserveableComponentBase;
import com.pi4j.component.button.Button;
import com.pi4j.component.button.ButtonHoldListener;
import com.pi4j.component.button.ButtonListener;
import com.pi4j.component.button.ButtonPressedListener;
import com.pi4j.component.button.ButtonReleasedListener;
import com.pi4j.component.button.ButtonState;
import com.pi4j.component.button.ButtonStateChangeEvent;
import com.pi4j.component.button.ButtonStateChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public abstract class ButtonBase
extends ObserveableComponentBase
implements Button {
    final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    final List<ScheduledFuture> holdEventFutures = new ArrayList<ScheduledFuture>();

    @Override
    public boolean isPressed() {
        return this.getState() == ButtonState.PRESSED;
    }

    @Override
    public boolean isReleased() {
        return this.getState() == ButtonState.RELEASED;
    }

    @Override
    public abstract ButtonState getState();

    @Override
    public boolean isState(ButtonState state) {
        return this.getState().equals((Object)state);
    }

    @Override
    public void addListener(ButtonStateChangeListener ... listener) {
        super.addListener(listener);
    }

    @Override
    public synchronized void removeListener(ButtonStateChangeListener ... listener) {
        super.removeListener(listener);
    }

    @Override
    public void addListener(ButtonPressedListener ... listener) {
        super.addListener(listener);
    }

    @Override
    public synchronized void removeListener(ButtonPressedListener ... listener) {
        super.removeListener(listener);
    }

    @Override
    public void addListener(ButtonReleasedListener ... listener) {
        super.addListener(listener);
    }

    @Override
    public synchronized void removeListener(ButtonReleasedListener ... listener) {
        super.removeListener(listener);
    }

    @Override
    public void addListener(long delay, ButtonHoldListener ... listener) {
        for (ButtonHoldListener l : listener) {
            super.addListener(new ButtonHoldListenerWrapper(delay, l));
        }
    }

    @Override
    public synchronized void removeListener(ButtonHoldListener ... listener) {
        ArrayList<ComponentListener> listeners_copy = new ArrayList<ComponentListener>(this.listeners);
        for (ButtonHoldListener bhl : listener) {
            for (ComponentListener cl : listeners_copy) {
                if (!(cl instanceof ButtonHoldListenerWrapper) || ((ButtonHoldListenerWrapper)cl).listener != bhl) continue;
                super.removeListener(cl);
            }
        }
    }

    protected synchronized void notifyListeners(final ButtonStateChangeEvent event) {
        if (!this.holdEventFutures.isEmpty()) {
            for (ScheduledFuture future : this.holdEventFutures) {
                future.cancel(false);
            }
            this.holdEventFutures.clear();
        }
        for (ComponentListener listener : this.listeners) {
            if (listener instanceof ButtonStateChangeListener) {
                ((ButtonStateChangeListener)listener).onStateChange(event);
            } else if (event.isPressed() && listener instanceof ButtonPressedListener) {
                ((ButtonPressedListener)listener).onButtonPressed(event);
            } else if (event.isReleased() && listener instanceof ButtonReleasedListener) {
                ((ButtonReleasedListener)listener).onButtonReleased(event);
            }
            if (!event.isPressed() || !(listener instanceof ButtonHoldListenerWrapper)) continue;
            final ButtonHoldListenerWrapper wrapper = (ButtonHoldListenerWrapper)listener;
            ScheduledFuture<?> scheduledFuture = this.executor.schedule(new Runnable(){

                @Override
                public void run() {
                    wrapper.listener.onButtonHold(event);
                }
            }, wrapper.delay, TimeUnit.MILLISECONDS);
            this.holdEventFutures.add(scheduledFuture);
        }
    }

    private class ButtonHoldListenerWrapper
    implements ButtonListener {
        public final ButtonHoldListener listener;
        public final long delay;

        public ButtonHoldListenerWrapper(long delay, ButtonHoldListener listener) {
            this.listener = listener;
            this.delay = delay;
        }
    }
}

