/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.component.potentiometer.microchip.impl;

import com.pi4j.component.potentiometer.microchip.MicrochipPotentiometerChannel;

enum DeviceControllerChannel {
    A(0, 2, 4, 8, 4, 1, 2),
    B(1, 3, 4, 128, 64, 16, 32),
    C(6, 8, 4, 8, 4, 1, 2),
    D(7, 9, 4, 128, 64, 16, 32);

    private byte volatileMemoryAddress;
    private byte nonVolatileMemoryAddress;
    private byte terminalControllAddress;
    private int hardwareConfigControlBit;
    private int terminalAConnectControlBit;
    private int terminalBConnectControlBit;
    private int wiperConnectControlBit;

    private DeviceControllerChannel(byte volatileMemoryAddress, byte nonVolatileMemoryAddress, byte terminalControllAddress, int hardwareConfigControlBit, int terminalAConnectControlBit, int terminalBConnectControlBit, int wiperConnectControlBit) {
        this.volatileMemoryAddress = volatileMemoryAddress;
        this.nonVolatileMemoryAddress = nonVolatileMemoryAddress;
        this.terminalControllAddress = terminalControllAddress;
        this.hardwareConfigControlBit = hardwareConfigControlBit;
        this.terminalAConnectControlBit = terminalAConnectControlBit;
        this.terminalBConnectControlBit = terminalBConnectControlBit;
        this.wiperConnectControlBit = wiperConnectControlBit;
    }

    byte getVolatileMemoryAddress() {
        return this.volatileMemoryAddress;
    }

    byte getNonVolatileMemoryAddress() {
        return this.nonVolatileMemoryAddress;
    }

    byte getTerminalControllAddress() {
        return this.terminalControllAddress;
    }

    int getHardwareConfigControlBit() {
        return this.hardwareConfigControlBit;
    }

    int getTerminalAConnectControlBit() {
        return this.terminalAConnectControlBit;
    }

    int getTerminalBConnectControlBit() {
        return this.terminalBConnectControlBit;
    }

    int getWiperConnectControlBit() {
        return this.wiperConnectControlBit;
    }

    static DeviceControllerChannel valueOf(MicrochipPotentiometerChannel channel) {
        if (channel == null) {
            return null;
        }
        for (DeviceControllerChannel dcChannel : DeviceControllerChannel.values()) {
            if (!dcChannel.name().equals(channel.name())) continue;
            return dcChannel;
        }
        throw new RuntimeException("There is no pendant for the given " + (Object)((Object)channel) + "'! Maybe there was another channel introduced for new " + "devices but only to MicrochipPotentiometerChannel but " + "in DeviceControllerChannel it is still missing.");
    }
}

