/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.component.sensor;

import com.pi4j.component.ComponentListener;
import com.pi4j.component.ObserveableComponentBase;
import com.pi4j.component.sensor.DistanceSensor;
import com.pi4j.component.sensor.DistanceSensorChangeEvent;
import com.pi4j.component.sensor.DistanceSensorListener;
import java.util.Date;
import java.util.SortedMap;
import java.util.TreeMap;

public abstract class DistanceSensorBase
extends ObserveableComponentBase
implements DistanceSensor {
    protected Date lastDistanceTimestamp = null;
    protected SortedMap<Double, Double> coordinates = new TreeMap<Double, Double>();

    @Override
    public Date getLastDistanceTimestamp() {
        return this.lastDistanceTimestamp;
    }

    @Override
    public void addListener(DistanceSensorListener ... listener) {
        super.addListener(listener);
    }

    @Override
    public synchronized void removeListener(DistanceSensorListener ... listener) {
        super.removeListener(listener);
    }

    protected synchronized void notifyListeners(DistanceSensorChangeEvent event) {
        this.lastDistanceTimestamp = event.timestamp;
        for (ComponentListener listener : this.listeners) {
            ((DistanceSensorListener)listener).onDistanceChange(event);
        }
    }

    @Override
    public boolean isValue(double value) {
        return this.getValue() == value;
    }

    @Override
    public boolean isValueInRange(double min, double max) {
        double value = this.getValue();
        return value >= min && value <= max;
    }

    @Override
    public double getDistance() {
        return this.getDistance(this.getValue());
    }

    @Override
    public double getDistance(double value) {
        Double lower = null;
        Double upper = null;
        for (Double coordinate : this.coordinates.keySet()) {
            if (value == coordinate) {
                return (Double)this.coordinates.get(coordinate);
            }
            if (value > coordinate) {
                lower = coordinate;
                continue;
            }
            if (!(value < coordinate)) continue;
            upper = coordinate;
            break;
        }
        if (lower == null) {
            return (Double)this.coordinates.get(this.coordinates.firstKey());
        }
        if (upper == null) {
            return (Double)this.coordinates.get(this.coordinates.lastKey());
        }
        Double minDistance = (Double)this.coordinates.get(lower);
        Double maxDistance = (Double)this.coordinates.get(upper);
        double diffPercentage = (value - lower) / (upper - lower);
        double diffDistance = (maxDistance - minDistance) * diffPercentage;
        return minDistance + diffDistance;
    }

    @Override
    public boolean isDistance(double distance) {
        return this.getDistance() == distance;
    }

    @Override
    public boolean isDistanceInRange(double min, double max) {
        double distance = this.getDistance();
        return distance >= min && distance <= max;
    }

    @Override
    public void addCalibrationCoordinate(double value, double distance) {
        this.coordinates.put(value, distance);
    }
}

