/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.gpio.extension.mcp;

import com.pi4j.gpio.extension.mcp.MCP23008Pin;
import com.pi4j.io.gpio.GpioProvider;
import com.pi4j.io.gpio.GpioProviderBase;
import com.pi4j.io.gpio.Pin;
import com.pi4j.io.gpio.PinMode;
import com.pi4j.io.gpio.PinPullResistance;
import com.pi4j.io.gpio.PinState;
import com.pi4j.io.gpio.event.PinDigitalStateChangeEvent;
import com.pi4j.io.gpio.event.PinEvent;
import com.pi4j.io.gpio.event.PinListener;
import com.pi4j.io.gpio.exception.InvalidPinException;
import com.pi4j.io.gpio.exception.UnsupportedPinPullResistanceException;
import com.pi4j.io.i2c.I2CBus;
import com.pi4j.io.i2c.I2CDevice;
import com.pi4j.io.i2c.I2CFactory;
import java.io.IOException;
import java.util.List;

public class MCP23008GpioProvider
extends GpioProviderBase
implements GpioProvider {
    public static final String NAME = "com.pi4j.gpio.extension.mcp.MCP23008GpioProvider";
    public static final String DESCRIPTION = "MCP23008 GPIO Provider";
    public static final int REGISTER_IODIR = 0;
    private static final int REGISTER_GPINTEN = 2;
    private static final int REGISTER_DEFVAL = 3;
    private static final int REGISTER_INTCON = 4;
    private static final int REGISTER_GPPU = 6;
    private static final int REGISTER_INTF = 7;
    public static final int REGISTER_GPIO = 9;
    private int currentStates = 0;
    private int currentDirection = 0;
    private int currentPullup = 0;
    private boolean i2cBusOwner = false;
    private I2CBus bus;
    private I2CDevice device;
    private GpioStateMonitor monitor = null;

    public MCP23008GpioProvider(int busNumber, int address) throws IOException {
        this(I2CFactory.getInstance((int)busNumber), address);
        this.i2cBusOwner = true;
    }

    public MCP23008GpioProvider(I2CBus bus, int address) throws IOException {
        this.bus = bus;
        this.device = bus.getDevice(address);
        this.currentStates = this.device.read(9);
        this.device.write(0, (byte)this.currentDirection);
        this.device.write(2, (byte)this.currentDirection);
        this.device.write(3, (byte)0);
        this.device.write(4, (byte)0);
        this.device.write(9, (byte)this.currentStates);
        this.device.write(6, (byte)this.currentPullup);
    }

    public String getName() {
        return NAME;
    }

    public void export(Pin pin, PinMode mode) {
        super.export(pin, mode);
        this.setMode(pin, mode);
    }

    public void unexport(Pin pin) {
        super.unexport(pin);
        this.setMode(pin, PinMode.DIGITAL_OUTPUT);
    }

    public void setMode(Pin pin, PinMode mode) {
        super.setMode(pin, mode);
        try {
            int pinAddress = pin.getAddress();
            if (mode == PinMode.DIGITAL_INPUT) {
                this.currentDirection |= pinAddress;
            } else if (mode == PinMode.DIGITAL_OUTPUT) {
                this.currentDirection &= ~pinAddress;
            }
            this.device.write(0, (byte)this.currentDirection);
            this.device.write(2, (byte)this.currentDirection);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        if (this.currentDirection > 0) {
            if (this.monitor == null) {
                this.monitor = new GpioStateMonitor(this.device);
                this.monitor.start();
            }
        } else if (this.monitor != null) {
            this.monitor.shutdown();
            this.monitor = null;
        }
    }

    public PinMode getMode(Pin pin) {
        return super.getMode(pin);
    }

    public void setState(Pin pin, PinState state) {
        super.setState(pin, state);
        try {
            int pinAddress = pin.getAddress();
            this.currentStates = state.isHigh() ? (this.currentStates |= pinAddress) : (this.currentStates &= ~pinAddress);
            this.device.write(9, (byte)this.currentStates);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public PinState getState(Pin pin) {
        PinState result = super.getState(pin);
        int pinAddress = pin.getAddress();
        result = (this.currentStates & pinAddress) == pinAddress ? PinState.HIGH : PinState.LOW;
        this.getPinCache(pin).setState(result);
        return result;
    }

    public void setPullResistance(Pin pin, PinPullResistance resistance) {
        if (!this.hasPin(pin)) {
            throw new InvalidPinException(pin);
        }
        if (!pin.getSupportedPinPullResistance().contains(resistance)) {
            throw new UnsupportedPinPullResistanceException(pin, resistance);
        }
        try {
            int pinAddress = pin.getAddress();
            this.currentPullup = resistance == PinPullResistance.PULL_UP ? (this.currentPullup |= pinAddress) : (this.currentPullup &= ~pinAddress);
            this.device.write(6, (byte)this.currentPullup);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        this.getPinCache(pin).setResistance(resistance);
    }

    public PinPullResistance getPullResistance(Pin pin) {
        return super.getPullResistance(pin);
    }

    public void shutdown() {
        if (this.isShutdown()) {
            return;
        }
        super.shutdown();
        try {
            if (this.monitor != null) {
                this.monitor.shutdown();
                this.monitor = null;
            }
            if (this.i2cBusOwner) {
                this.bus.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private class GpioStateMonitor
    extends Thread {
        private I2CDevice device;
        private boolean shuttingDown = false;

        public GpioStateMonitor(I2CDevice device) {
            this.device = device;
        }

        public void shutdown() {
            this.shuttingDown = true;
        }

        @Override
        public void run() {
            while (!this.shuttingDown) {
                try {
                    int pinInterrupt;
                    if (MCP23008GpioProvider.this.currentDirection > 0 && (pinInterrupt = this.device.read(7)) > 0) {
                        int pinInterruptState = this.device.read(9);
                        for (Pin pin : MCP23008Pin.ALL) {
                            this.evaluatePinForChange(pin, pinInterruptState);
                        }
                    }
                    Thread.currentThread();
                    Thread.sleep(50L);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

        private void evaluatePinForChange(Pin pin, int state) {
            int pinAddress;
            if (MCP23008GpioProvider.this.getPinCache(pin).isExported() && (state & (pinAddress = pin.getAddress())) != (MCP23008GpioProvider.this.currentStates & pinAddress)) {
                PinState newState = (state & pinAddress) == pinAddress ? PinState.HIGH : PinState.LOW;
                MCP23008GpioProvider.this.getPinCache(pin).setState(newState);
                if (newState.isHigh()) {
                    MCP23008GpioProvider.this.currentStates = MCP23008GpioProvider.this.currentStates | pinAddress;
                } else {
                    MCP23008GpioProvider.this.currentStates = MCP23008GpioProvider.this.currentStates & ~pinAddress;
                }
                this.dispatchPinChangeEvent(pin.getAddress(), newState);
            }
        }

        private void dispatchPinChangeEvent(int pinAddress, PinState state) {
            for (Pin pin : MCP23008GpioProvider.this.listeners.keySet()) {
                if (pin.getAddress() != pinAddress) continue;
                for (PinListener listener : (List)MCP23008GpioProvider.this.listeners.get(pin)) {
                    listener.handlePinEvent((PinEvent)new PinDigitalStateChangeEvent((Object)this, pin, state));
                }
            }
        }
    }
}

