/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.util;

public class StringUtil {
    public static final String EMPTY = "";
    public static final char DEFAULT_PAD_CHAR = ' ';

    public static boolean isNullOrEmpty(String data, boolean trim) {
        if (data == null) {
            return true;
        }
        String test = data;
        if (trim) {
            test = data.trim();
        }
        return test.length() <= 0;
    }

    public static boolean isNullOrEmpty(String data) {
        return StringUtil.isNullOrEmpty(data, false);
    }

    public static boolean isNotNullOrEmpty(String data) {
        return StringUtil.isNotNullOrEmpty(data, false);
    }

    public static boolean isNotNullOrEmpty(String data, boolean trim) {
        return !StringUtil.isNullOrEmpty(data, trim);
    }

    public static boolean contains(String source, String target) {
        return null != source && null != target && source.contains(target);
    }

    public static boolean contains(String source, String[] targets) {
        if (null != source && null != targets) {
            for (String target : targets) {
                if (!source.contains(target)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean contains(String[] sources, String target) {
        if (null != sources && null != target) {
            for (String source : sources) {
                if (!StringUtil.contains(source, target)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean contains(String[] sources, String[] targets) {
        if (null != sources && null != targets) {
            for (String source : sources) {
                if (!StringUtil.contains(source, targets)) continue;
                return true;
            }
        }
        return false;
    }

    public static String create(int length) {
        return StringUtil.create(' ', length);
    }

    public static String create(char c, int length) {
        StringBuilder sb = new StringBuilder(length);
        for (int index = 0; index < length; ++index) {
            sb.append(c);
        }
        return sb.toString();
    }

    public static String create(String s, int length) {
        StringBuilder sb = new StringBuilder(length * s.length());
        for (int index = 0; index < length; ++index) {
            sb.append(s);
        }
        return sb.toString();
    }

    public static String padLeft(String data, int length) {
        return StringUtil.padLeft(data, ' ', length);
    }

    public static String padLeft(String data, char pad, int length) {
        StringBuilder sb = new StringBuilder(data.length() + length);
        for (int index = 0; index < length; ++index) {
            sb.append(pad);
        }
        sb.append(data);
        return sb.toString();
    }

    public static String padLeft(String data, String pad, int length) {
        StringBuilder sb = new StringBuilder(data.length() + length * pad.length());
        for (int index = 0; index < length; ++index) {
            sb.append(pad);
        }
        sb.append(data);
        return sb.toString();
    }

    public static String padRight(String data, int length) {
        return StringUtil.padRight(data, ' ', length);
    }

    public static String padRight(String data, char pad, int length) {
        StringBuilder sb = new StringBuilder(data.length() + length);
        sb.append(data);
        for (int index = 0; index < length; ++index) {
            sb.append(pad);
        }
        return sb.toString();
    }

    public static String padRight(String data, String pad, int length) {
        StringBuilder sb = new StringBuilder(data.length() + length * pad.length());
        sb.append(data);
        for (int index = 0; index < length; ++index) {
            sb.append(pad);
        }
        return sb.toString();
    }

    public static String pad(String data, int length) {
        return StringUtil.pad(data, ' ', length);
    }

    public static String pad(String data, char pad, int length) {
        return StringUtil.create(pad, length) + data + StringUtil.create(pad, length);
    }

    public static String pad(String data, String pad, int length) {
        return StringUtil.create(pad, length) + data + StringUtil.create(pad, length);
    }

    public static String padCenter(String data, int length) {
        return StringUtil.padCenter(data, ' ', length);
    }

    public static String padCenter(String data, char pad, int length) {
        if (data.length() < length) {
            int needed = length - data.length();
            int padNeeded = needed / 2;
            StringBuilder result = new StringBuilder();
            result.append(StringUtil.create(pad, padNeeded));
            result.append(data);
            result.append(StringUtil.create(pad, padNeeded));
            int remaining = length - result.length();
            result.append(StringUtil.create(pad, remaining));
            return result.toString();
        }
        return data;
    }

    public static String trimLeft(String data) {
        return StringUtil.trimLeft(data, ' ');
    }

    public static String trimLeft(String data, char trim) {
        for (int index = 0; index < data.length(); ++index) {
            if (data.charAt(index) == trim) continue;
            return data.substring(index);
        }
        return EMPTY;
    }

    public static String trimRight(String data) {
        return StringUtil.trimRight(data, ' ');
    }

    public static String trimRight(String data, char trim) {
        int count = 0;
        for (int index = data.length(); index > 0; --index) {
            if (data.charAt(index - 1) == trim) {
                ++count;
                continue;
            }
            return data.substring(0, data.length() - count);
        }
        return EMPTY;
    }

    public static String trim(String data) {
        return StringUtil.trim(data, ' ');
    }

    public static String trim(String data, char trim) {
        String result = StringUtil.trimLeft(data, trim);
        return StringUtil.trimRight(result, trim);
    }
}

