/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.result;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.Result;
import com.google.zxing.client.result.ISBNParsedResult;
import com.google.zxing.client.result.ResultParser;

public class ISBNResultParser
extends ResultParser {
    private ISBNResultParser() {
    }

    public static ISBNParsedResult parse(Result result) {
        BarcodeFormat format = result.getBarcodeFormat();
        if (!BarcodeFormat.EAN_13.equals(format)) {
            return null;
        }
        String rawText = result.getText();
        if (rawText == null) {
            return null;
        }
        int length = rawText.length();
        if (length != 13) {
            return null;
        }
        if (!rawText.startsWith("978") && !rawText.startsWith("979")) {
            return null;
        }
        return new ISBNParsedResult(rawText);
    }
}

