/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.spi.impl;

import com.pi4j.io.spi.SpiChannel;
import com.pi4j.io.spi.SpiDevice;
import com.pi4j.io.spi.SpiMode;
import com.pi4j.wiringpi.Spi;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class SpiDeviceImpl
implements SpiDevice {
    protected final SpiChannel channel;
    protected final SpiMode mode;

    public SpiDeviceImpl(SpiChannel channel, int speed, SpiMode mode) throws IOException {
        this.channel = channel;
        this.mode = mode;
        try {
            int fd = Spi.wiringPiSPISetupMode(channel.getChannel(), speed, mode.getMode());
            if (fd <= -1) {
                throw new IOException("SPI port setup failed, wiringPiSPISetupMode returned " + fd);
            }
        }
        catch (UnsatisfiedLinkError e) {
            throw new IOException("SPI port setup failed, no SPI available.", e);
        }
    }

    public SpiDeviceImpl(SpiChannel channel, int speed) throws IOException {
        this(channel, speed, DEFAULT_SPI_MODE);
    }

    public SpiDeviceImpl(SpiChannel channel, SpiMode mode) throws IOException {
        this(channel, 1000000, mode);
    }

    public SpiDeviceImpl(SpiChannel channel) throws IOException {
        this(channel, 1000000);
    }

    @Override
    public String write(String data, String charset) throws IOException {
        byte[] buffer = data.getBytes(charset);
        return new String(this.write(buffer), charset);
    }

    @Override
    public String write(String data, Charset charset) throws IOException {
        byte[] buffer = data.getBytes(charset);
        return new String(this.write(buffer), charset);
    }

    @Override
    public ByteBuffer write(ByteBuffer data) throws IOException {
        return ByteBuffer.wrap(this.write(data.array()));
    }

    @Override
    public byte[] write(InputStream input) throws IOException {
        if (input.available() <= 0) {
            throw new IOException("No available bytes in input stream to write to SPI channel: " + this.channel.getChannel());
        }
        if (input.available() > 2048) {
            throw new IOException("Number of bytes in stream exceed the maximum bytes allowed to write SPI channel in a single call");
        }
        byte[] buffer = new byte[2048];
        int length = input.read(buffer, 0, 2048);
        return this.write(buffer, 0, length);
    }

    @Override
    public int write(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = this.write(input);
        output.write(buffer);
        return buffer.length;
    }

    @Override
    public byte[] write(byte ... data) throws IOException {
        return this.write(data, 0, data.length);
    }

    @Override
    public short[] write(short ... data) throws IOException {
        return this.write(data, 0, data.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] write(byte[] data, int start, int length) throws IOException {
        if ((length = Math.min(data.length - start, length)) > 2048) {
            throw new IOException("Number of bytes in data to write exceed the maximum bytes allowed to write SPI channel in a single call");
        }
        byte[] buffer = new byte[length];
        System.arraycopy(data, start, buffer, 0, length);
        SpiChannel spiChannel = this.channel;
        synchronized (spiChannel) {
            if (Spi.wiringPiSPIDataRW((int)this.channel.getChannel(), buffer) <= 0) {
                throw new IOException("Failed to write data to SPI channel: " + this.channel.getChannel());
            }
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short[] write(short[] data, int start, int length) throws IOException {
        if ((length = Math.min(data.length - start, length)) > 2048) {
            throw new IOException("Number of bytes in data to write exceed the maximum bytes allowed to write SPI channel in a single call");
        }
        short[] buffer = new short[length];
        System.arraycopy(data, start, buffer, 0, length);
        SpiChannel spiChannel = this.channel;
        synchronized (spiChannel) {
            if (Spi.wiringPiSPIDataRW((int)this.channel.getChannel(), buffer) <= 0) {
                throw new IOException("Failed to write data to SPI channel: " + this.channel.getChannel());
            }
            return buffer;
        }
    }
}

