/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.result;

import com.google.zxing.Result;
import com.google.zxing.client.result.CalendarParsedResult;
import com.google.zxing.client.result.ResultParser;
import com.google.zxing.client.result.VCardResultParser;

final class VEventResultParser
extends ResultParser {
    private VEventResultParser() {
    }

    public static CalendarParsedResult parse(Result result) {
        double longitude;
        double latitude;
        String rawText = result.getText();
        if (rawText == null) {
            return null;
        }
        int vEventStart = rawText.indexOf("BEGIN:VEVENT");
        if (vEventStart < 0) {
            return null;
        }
        String summary = VCardResultParser.matchSingleVCardPrefixedField("SUMMARY", rawText, true);
        String start = VCardResultParser.matchSingleVCardPrefixedField("DTSTART", rawText, true);
        String end = VCardResultParser.matchSingleVCardPrefixedField("DTEND", rawText, true);
        String location = VCardResultParser.matchSingleVCardPrefixedField("LOCATION", rawText, true);
        String description = VCardResultParser.matchSingleVCardPrefixedField("DESCRIPTION", rawText, true);
        String geoString = VCardResultParser.matchSingleVCardPrefixedField("GEO", rawText, true);
        if (geoString == null) {
            latitude = Double.NaN;
            longitude = Double.NaN;
        } else {
            int semicolon = geoString.indexOf(59);
            try {
                latitude = Double.parseDouble(geoString.substring(0, semicolon));
                longitude = Double.parseDouble(geoString.substring(semicolon + 1));
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
        try {
            return new CalendarParsedResult(summary, start, end, location, null, description, latitude, longitude);
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
    }
}

